import 'package:flutter/material.dart';
import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:fl_sevengen_society_user_app/api_constants.dart';

class CloseReferralScreen extends StatelessWidget {
  final int referralId;

  const CloseReferralScreen({super.key, required this.referralId});

  @override
  Widget build(BuildContext context) {
    final TextEditingController amountController = TextEditingController();

    return Scaffold(
      appBar: AppBar(title: const Text("Closing Referral")),
      body: Padding(
        padding: const EdgeInsets.all(16),
        child: Column(
          children: [
            TextField(
              controller: amountController,
              keyboardType: TextInputType.number,
              decoration: const InputDecoration(
                labelText: "Amount",
                prefixText: "₹ ",
                border: OutlineInputBorder(),
              ),
            ),
            const SizedBox(height: 20),
            ElevatedButton(
              onPressed: () async {
                await http.post(
                  Uri.parse("$apiBaseUrl/referral_close.php"),
                  headers: {"Content-Type": "application/json"},
                  body: jsonEncode({
                    "id": referralId,
                    "amount": amountController.text,
                  }),
                );

                Navigator.pop(context, true);
              },
              child: const Text("Save"),
            ),
          ],
        ),
      ),
    );
  }
}
