import 'package:fl_sevengen_society_user_app/localization/localization_const.dart';
import 'package:flutter/material.dart';

import '../../theme/theme.dart';

class TermsAndConditionScreen extends StatefulWidget {
  const TermsAndConditionScreen({super.key});

  @override
  State<TermsAndConditionScreen> createState() =>
      _TermsAndConditionScreenState();
}

class _TermsAndConditionScreenState extends State<TermsAndConditionScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: whiteColor,
        elevation: 0.0,
        titleSpacing: 0.0,
        centerTitle: false,
        automaticallyImplyLeading: false,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: black33Color,
          ),
        ),
        title: Text(
          getTranslate(context, 'terms_and_conditions.Terms_and_condition'),
          style: semibold18Black33,
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.fromLTRB(
          fixPadding * 2.0,
          fixPadding,
          fixPadding * 2.0,
          fixPadding * 2.0,
        ),
        physics: const BouncingScrollPhysics(),
        children: const [
          // 1. Introduction
          Text(
            "1. Introduction",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "By downloading, accessing, or using the RMBF Erode United mobile application (\"App\"), users agree to comply with these Terms & Conditions. The App provides information, services, and communication features related to RMBF Erode United. Users must read these terms carefully. If you do not agree, please stop using the App.",
            style: medium15Grey,
          ),
          heightSpace,

          // 2. User Responsibilities
          Text(
            "2. User Responsibilities",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "Users must provide accurate information during registration and while using the App. Any misuse—including false data, unauthorized access, or activities disrupting the App—is strictly prohibited. Users are responsible for maintaining the confidentiality of account details and actions performed under their account.",
            style: medium15Grey,
          ),
          heightSpace,

          // 3. Use of Services
          Text(
            "3. Use of Services",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "The App offers features such as updates, communication tools, member information, and community-related services. All content is for informational purposes and may change without prior notice. RMBF Erode United reserves the right to modify, limit, or terminate any feature or service at any time for maintenance or policy violations.",
            style: medium15Grey,
          ),
          heightSpace,

          // 4. Data Privacy & Security
          Text(
            "4. Data Privacy & Security",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "By using the App, you agree to the collection and processing of your personal information as per the Privacy Policy. Although reasonable security measures are taken, no system is fully secure. RMBF Erode United is not responsible for data breaches or unauthorized access beyond its control. Users should avoid sharing sensitive information in public sections of the App.",
            style: medium15Grey,
          ),
          heightSpace,

          // 5. Limitation of Liability & Governing Law
          Text(
            "5. Limitation of Liability & Governing Law",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "RMBF Erode United is not liable for any direct or indirect damages resulting from App usage, including technical failures, network issues, or third-party actions. Continued use of the App signifies acceptance of these terms. These Terms & Conditions are governed by the laws of Tamil Nadu, India, and disputes fall under the jurisdiction of courts in Erode.",
            style: medium15Grey,
          ),
        ],
      ),
    );
  }
}
