import 'package:fl_sevengen_society_user_app/localization/localization_const.dart';
import 'package:fl_sevengen_society_user_app/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class PrivacyPolicyScreen extends StatefulWidget {
  const PrivacyPolicyScreen({super.key});

  @override
  State<PrivacyPolicyScreen> createState() => _PrivacyPolicyScreenState();
}

class _PrivacyPolicyScreenState extends State<PrivacyPolicyScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: primaryColor,
        elevation: 0.0,
        titleSpacing: 0.0,
        centerTitle: false,
        automaticallyImplyLeading: false,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: Colors.white,
            size: 18,
          ),
        ),
        title: Text(
          getTranslate(context, 'privacy_policy.privacy_policy'),
          style: const TextStyle(
            color: Colors.white,
            fontSize: 18,
            fontWeight: FontWeight.w600,
          ),
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.fromLTRB(
          fixPadding * 2.0,
          fixPadding,
          fixPadding * 2.0,
          fixPadding * 2.0,
        ),
        physics: const BouncingScrollPhysics(),
        children: const [
          // 1. Introduction
          Text(
            "1. Introduction",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "This Privacy Policy explains how RMBF Erode United (the \"App\" or \"we\") collects, uses, shares, and protects the personal information of users who download or use the App. By using the App, you consent to the collection and processing of your information as described in this policy. Please read the policy carefully and contact us if you have any questions.",
            style: medium15Grey,
          ),
          SizedBox(height: 24), // Replaced heightSpace with explicit SizedBox

          // 2. Information We Collect
          Text(
            "2. Information We Collect",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "We may collect information you provide directly (such as name, contact details, membership information) and information collected automatically (such as device identifiers, usage data, and analytics). Collection is limited to what is necessary to operate and improve the App and to provide the services you request.",
            style: medium15Grey,
          ),
          SizedBox(height: 24),

          // 3. How We Use Information
          Text(
            "3. How We Use Information",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "Your information is used to deliver App features, communicate updates and events, personalize your experience, and improve our services. We may also use data for security, fraud prevention, and to comply with legal obligations. We will not sell your personal information to third parties.",
            style: medium15Grey,
          ),
          SizedBox(height: 24),

          // 4. Data Security & Sharing
          Text(
            "4. Data Security & Sharing",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "We implement reasonable technical and organizational measures to protect your data from unauthorized access, disclosure, or loss. However, no system is completely secure and we cannot guarantee absolute protection. We may share information with trusted service providers who assist in operating the App and with law enforcement or regulators when required by law.",
            style: medium15Grey,
          ),
          SizedBox(height: 24),

          // 5. Your Rights & Governing Law
          Text(
            "5. Your Rights & Governing Law",
            style: semibold18Black33,
          ),
          SizedBox(height: 6),
          Text(
            "You may access, update, or request deletion of your personal information where applicable. If you have concerns about your privacy, contact us through the channels provided in the App. This Privacy Policy is governed by the laws of Tamil Nadu, India, and any disputes will be subject to the jurisdiction of courts in Erode.",
            style: medium15Grey,
          ),
          SizedBox(height: 24),
        ],
      ),
    );
  }
}
