import 'package:flutter/material.dart';

class AboutRMBFScreen extends StatelessWidget {
  const AboutRMBFScreen({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          "About RMBF",
          style: TextStyle(
            fontSize: 18,
            color: Colors.white,
          ),
        ),
        backgroundColor: Theme.of(context).primaryColor,
        foregroundColor: Colors.white, // Makes back arrow white
        iconTheme: const IconThemeData(color: Colors.white), // Ensures back arrow is white
      ),
      body: SingleChildScrollView(
        padding: const EdgeInsets.all(16),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            // About the Project
            _sectionTitle("About The Project"),
            const SizedBox(height: 8),

            _sectionText(
              "The RMBF Business Club App is designed as a digital networking platform "
                  "specifically for members of the RMBF (Rotary Means Business Fellowship), "
                  "promoting professional connections, business collaborations, and mentorship "
                  "within the Rotary community. This case study examines the app's user experience "
                  "journey and highlights its core features.",
            ),

            const SizedBox(height: 25),

            // Problem Statement
            _sectionTitle("Problem Statement"),
            const SizedBox(height: 8),

            _sectionText(
              "Members of the RMBF (Rotary Means Business Fellowship) often face challenges "
                  "in finding and connecting with fellow Rotary professionals for business growth, "
                  "mentorship, and collaboration. Despite their shared affiliation, members struggle "
                  "to access an efficient platform that centralizes networking opportunities, "
                  "business resources, and events relevant to their interests.",
            ),

            const SizedBox(height: 30),

            // User Persona Card
            _personaCard(),
          ],
        ),
      ),
    );
  }

  // Reusable title widget
  Widget _sectionTitle(String title) {
    return Text(
      title,
      style: const TextStyle(
        fontSize: 20,
        fontWeight: FontWeight.bold,
        color: Colors.blue,
      ),
    );
  }

  // Reusable paragraph text widget
  Widget _sectionText(String text) {
    return Text(
      text,
      style: const TextStyle(
        fontSize: 15,
        height: 1.5,
        color: Colors.black87,
      ),
    );
  }

  // User Persona Card
  Widget _personaCard() {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.all(16),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(12),
        border: Border.all(color: Colors.blue.shade200),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: Colors.black.withOpacity(0.05),
            blurRadius: 8,
            spreadRadius: 2,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const Text(
            "Bio",
            style: TextStyle(
              fontSize: 18,
              fontWeight: FontWeight.bold,
              color: Colors.blue,
            ),
          ),

          const SizedBox(height: 8),

          const Text(
            "David is an Austin-based entrepreneur in eco-friendly manufacturing and "
                "a longtime RMBF member. Through the Rotary Means Business Fellowship, "
                "he seeks meaningful partnerships, mentorship, and efficient networking "
                "to support his business and community involvement.",
            style: TextStyle(fontSize: 14, height: 1.5),
          ),

          const SizedBox(height: 12),

          const Center(
            child: Text(
              "“Connecting Rotary Professionals for Purposeful\n"
                  "Partnerships and Business Growth”",
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: 14,
                fontStyle: FontStyle.italic,
                fontWeight: FontWeight.w600,
                color: Colors.orange,
              ),
            ),
          ),

          const SizedBox(height: 20),

          const Text(
            "Goals",
            style: TextStyle(
              fontSize: 16,
              fontWeight: FontWeight.bold,
              color: Colors.blue,
            ),
          ),

          const SizedBox(height: 6),

          _bulletPoint("Find new clients and projects through networking within the club"),
          _bulletPoint("Make business referrals through the app"),
          _bulletPoint("Check club member details and connect with business members"),
          _bulletPoint("Stay connected with RMBF events and activities"),

          const SizedBox(height: 16),

          const Text(
            "Frustrations",
            style: TextStyle(
              fontSize: 16,
              fontWeight: FontWeight.bold,
              color: Colors.red,
            ),
          ),

          const SizedBox(height: 6),

          _bulletPoint("Difficult to refer business members for collaboration"),
          _bulletPoint("Difficult to find new clients, projects and events"),
        ],
      ),
    );
  }

  // Reusable bullet point widget
  Widget _bulletPoint(String text) {
    return Padding(
      padding: const EdgeInsets.only(bottom: 6),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const Text("•  ", style: TextStyle(fontSize: 16)),
          Expanded(
            child: Text(
              text,
              style: const TextStyle(fontSize: 14),
            ),
          ),
        ],
      ),
    );
  }
}
