import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class CalendarDialog extends StatelessWidget {
  const CalendarDialog({super.key, this.selectedDate});

  final DateTime? selectedDate;

  @override
  Widget build(BuildContext context) {
    return Dialog(
      insetPadding: const EdgeInsets.all(fixPadding * 2.0),
      backgroundColor: whiteColor,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(10.0),
      ),
      child: ListView(
        shrinkWrap: true,
        padding: const EdgeInsets.only(top: fixPadding),
        physics: const BouncingScrollPhysics(),
        children: [
          Stack(
            children: [
              Center(
                child: Text(
                  tr(context, 'add_delivery.select_date'),
                  style: regular18Black,
                  textAlign: TextAlign.center,
                ),
              ),
              Positioned(
                right: 0,
                child: Padding(
                  padding: const EdgeInsets.symmetric(horizontal: fixPadding),
                  child: InkWell(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: const Icon(
                      Icons.close,
                      size: 22.0,
                      color: greyColor,
                    ),
                  ),
                ),
              )
            ],
          ),
          CalendarDatePicker(
            initialDate: selectedDate ?? DateTime.now(),
            firstDate: DateTime.now(),
            lastDate: DateTime.now().add(const Duration(days: 36500)),
            onDateChanged: (date) {
              Navigator.pop(context, date);
            },
          )
        ],
      ),
    );
  }
}
