import 'package:dotted_border/dotted_border.dart';
import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class SocietyPaymentScreen extends StatefulWidget {
  const SocietyPaymentScreen({super.key});

  @override
  State<SocietyPaymentScreen> createState() => _SocietyPaymentScreenState();
}

class _SocietyPaymentScreenState extends State<SocietyPaymentScreen> {
  final paymentList = [
    {
      "title": "Maintenance Jan 2024",
      "amount": "\$20.00",
      "dateTime": "4 jan , 3:30 PM",
      "status": "Paid"
    },
    {
      "title": "Maintenance Feb 2024",
      "amount": "\$20.00",
      "dateTime": "5 march 2024",
      "status": "Pending"
    },
    {
      "title": "Society welfare fund",
      "amount": "\$25.00",
      "dateTime": "10 march 2024",
      "status": "Failed"
    },
    {
      "title": "Security  Deposit",
      "amount": "\$50.00",
      "dateTime": "10 march 2024",
      "status": "Pending"
    },
    {
      "title": "Society welfare fund",
      "amount": "\$15.00",
      "dateTime": "4 jan , 3:30 PM",
      "status": "Paid"
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'society_payment.society_payment'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.only(bottom: fixPadding),
        children: [
          topImage(),
          heightSpace,
          paymentListContent(),
        ],
      ),
    );
  }

  Widget paymentListContent() {
    return ColumnBuilder(
      itemBuilder: (context, index) {
        final itemData = paymentList[index];
        final status = itemData['status'];

        return Container(
          margin: const EdgeInsets.symmetric(vertical: fixPadding),
          padding: const EdgeInsets.symmetric(
            vertical: fixPadding * 1.5,
            horizontal: fixPadding * 2.0,
          ),
          width: double.maxFinite,
          color: whiteColor,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          itemData['title'].toString(),
                          style: medium16Primary,
                          overflow: TextOverflow.ellipsis,
                        ),
                        heightSpace,
                        Text(
                          itemData['amount'].toString(),
                          style: regular16Black,
                          overflow: TextOverflow.ellipsis,
                        )
                      ],
                    ),
                  ),
                  widthSpace,
                  if (status == "Paid")
                    statusButton(
                      greenColor,
                      tr(context, 'society_payment.paid'),
                          () {
                        Navigator.pushNamed(context, '/paymentSuccess');
                      },
                    ),
                  if (status == "Pending")
                    statusButton(
                      primaryColor,
                      tr(context, 'society_payment.pending'),
                          () {
                        Navigator.pushNamed(context, '/selectPayment');
                      },
                    ),
                  if (status == "Failed")
                    statusButton(
                      lightRedColor,
                      tr(context, 'society_payment.failed'),
                          () {
                        Navigator.pushNamed(context, '/selectPayment');
                      },
                    ),
                ],
              ),
              Padding(
                padding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.5,
                ),
                child: DottedBorder(
                  // 👇 New API: use options instead of padding/dashPattern directly
                  options: RectDottedBorderOptions(
                    color: greyD4Color,
                    dashPattern: const [2, 4],
                    padding: EdgeInsets.zero,
                    strokeWidth: 1,
                  ),
                  child: SizedBox(
                    width: double.maxFinite,
                    height: 1,
                  ),
                ),
              ),
              Text(
                "${status == "Paid" ? tr(context, 'society_payment.paid_on') : tr(context, 'society_payment.due_date')} ${itemData['dateTime']}",
                style: regular15Grey,
                overflow: TextOverflow.ellipsis,
              ),
            ],
          ),
        );
      },
      itemCount: paymentList.length,
    );
  }

  Widget statusButton(Color color, String title, Function() onTap) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: 100.0,
        padding: const EdgeInsets.all(fixPadding * 0.8),
        decoration: BoxDecoration(
          color: color,
          borderRadius: BorderRadius.circular(5.0),
          boxShadow: [
            BoxShadow(
              color: color.withOpacity(0.15),
              blurRadius: 12.0,
              offset: const Offset(0, 6),
            ),
          ],
        ),
        child: Text(
          title,
          style: medium16White,
          overflow: TextOverflow.ellipsis,
          textAlign: TextAlign.center,
        ),
      ),
    );
  }

  Widget topImage() {
    return Image.asset(
      "assets/community/payment-image.png",
      height: 128.0,
      width: double.maxFinite,
      fit: BoxFit.cover,
    );
  }
}
