import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class SelectAmenitiesScreen extends StatefulWidget {
  const SelectAmenitiesScreen({super.key});

  @override
  State<SelectAmenitiesScreen> createState() => _SelectAmenitiesScreenState();
}

class _SelectAmenitiesScreenState extends State<SelectAmenitiesScreen> {
  final amenitiesList = [
    {
      "title": "Community hall",
      "price": "\$60",
      "isPaid": true,
    },
    {
      "title": "Club house",
      "price": "\$20",
      "isPaid": false,
    },
    {
      "title": "Swimming pool",
      "price": "\$10",
      "isPaid": false,
    },
    {
      "title": "Common plot",
      "price": "\$40",
      "isPaid": true,
    },
    {
      "title": "Guest house",
      "price": "\$20",
      "isPaid": true,
    },
    {
      "title": "Tennis room",
      "price": "\$25",
      "isPaid": false,
    },
    {
      "title": "Indoor theater",
      "price": "\$10",
      "isPaid": true,
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'select_amenities.select_amenities'),
          style: medium18Black,
        ),
      ),
      body: ListView.builder(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.symmetric(vertical: fixPadding),
        itemCount: amenitiesList.length,
        itemBuilder: (context, index) {
          final itemData = amenitiesList[index];
          return GestureDetector(
            onTap: () {
              Navigator.pushNamed(context, '/bookAmenitiesDetail');
            },
            child: Container(
              margin: const EdgeInsets.symmetric(vertical: fixPadding),
              padding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 2.0, vertical: fixPadding),
              width: double.maxFinite,
              decoration: BoxDecoration(
                color: whiteColor,
                boxShadow: boxShadow2,
              ),
              child: Row(
                children: [
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          itemData['title'].toString(),
                          style: regular17Black,
                        ),
                        height5Space,
                        Text(
                          "${itemData['price']} ${tr(context, 'select_amenities.per_day')}",
                          style: regular15Grey,
                        )
                      ],
                    ),
                  ),
                  widthSpace,
                  itemData['isPaid'] == true
                      ? Text(tr(context, 'select_amenities.paid'),
                          style: medium16Green)
                      : Text(
                          tr(context, 'select_amenities.free'),
                          style: medium16Primary,
                        )
                ],
              ),
            ),
          );
        },
      ),
    );
  }
}
