import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class RaisedNewComplaintScreen extends StatefulWidget {
  const RaisedNewComplaintScreen({super.key});

  @override
  State<RaisedNewComplaintScreen> createState() =>
      _RaisedNewComplaintScreenState();
}

class _RaisedNewComplaintScreenState extends State<RaisedNewComplaintScreen> {
  final complaintTypeList = [
    translate('raised_new_complaint.personal'),
    translate('raised_new_complaint.community')
  ];

  int selectedComplaintType = 0;

  final complaintImagesList = ["assets/complaint/image-1.png"];

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'raised_new_complaint.complaint'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        children: [
          addUserImage(),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          complaintNameField(),
          heightSpace,
          heightSpace,
          height5Space,
          selectComplaintType(),
          heightSpace,
          heightSpace,
          height5Space,
          briefComplaintField(size),
          heightSpace,
          heightSpace,
          height5Space,
          attachPhotos(),
        ],
      ),
      bottomNavigationBar: submitButton(context, size),
    );
  }

  Widget submitButton(BuildContext context, Size size) {
    return GestureDetector(
      onTap: () {
        complaintRaiseSuccessDialog(context, size);
      },
      child: Container(
        margin: const EdgeInsets.symmetric(
            vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
        padding: const EdgeInsets.symmetric(
            horizontal: fixPadding * 2.0, vertical: fixPadding * 1.1),
        width: double.maxFinite,
        decoration: BoxDecoration(
          color: primaryColor,
          borderRadius: BorderRadius.circular(10.0),
          boxShadow: buttonShadow,
        ),
        child: Text(
          tr(context, 'raised_new_complaint.submit_complaint'),
          style: medium20White,
          overflow: TextOverflow.ellipsis,
          textAlign: TextAlign.center,
        ),
      ),
    );
  }

  Future<dynamic> complaintRaiseSuccessDialog(BuildContext context, Size size) {
    return showDialog(
      context: context,
      builder: (context) {
        return Dialog(
          surfaceTintColor: Colors.transparent,
          shape: const RoundedRectangleBorder(),
          backgroundColor: whiteColor,
          insetPadding: EdgeInsets.symmetric(horizontal: size.width * 0.2),
          child: ListView(
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.all(fixPadding * 2.0),
            children: [
              Text(
                tr(context, 'raised_new_complaint.complaint_raised'),
                style: medium15Black,
                textAlign: TextAlign.center,
              ),
              heightSpace,
              Text(
                tr(context, 'raised_new_complaint.success_text'),
                style: regular14Grey,
                textAlign: TextAlign.center,
              ),
              heightSpace,
              heightSpace,
              GestureDetector(
                onTap: () {
                  Navigator.pushNamedAndRemoveUntil(
                      context, '/bottombar', (route) => false);
                },
                child: Container(
                  margin:
                      const EdgeInsets.symmetric(horizontal: fixPadding * 1.5),
                  padding: const EdgeInsets.all(fixPadding * 0.75),
                  width: double.maxFinite,
                  decoration: BoxDecoration(
                    color: primaryColor,
                    borderRadius: BorderRadius.circular(5.0),
                    boxShadow: buttonShadow,
                  ),
                  child: Text(
                    tr(context, 'raised_new_complaint.okay'),
                    style: medium18White,
                    textAlign: TextAlign.center,
                    overflow: TextOverflow.ellipsis,
                  ),
                ),
              )
            ],
          ),
        );
      },
    );
  }

  Widget attachPhotos() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'raised_new_complaint.attach_photo')),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: SingleChildScrollView(
            physics: const BouncingScrollPhysics(),
            scrollDirection: Axis.horizontal,
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding, vertical: fixPadding * 2.0),
            child: Row(
              children: [
                Row(
                  children: List.generate(
                    complaintImagesList.length,
                    (index) {
                      return Container(
                        margin:
                            const EdgeInsets.symmetric(horizontal: fixPadding),
                        height: 100,
                        width: 110.0,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10.0),
                          image: DecorationImage(
                            image: AssetImage(
                              complaintImagesList[index].toString(),
                            ),
                            fit: BoxFit.cover,
                          ),
                        ),
                      );
                    },
                  ),
                ),
                GestureDetector(
                  onTap: () {
                    imageBottomSheet(
                        tr(context, 'raised_new_complaint.add_image'));
                  },
                  child: Container(
                    margin: const EdgeInsets.symmetric(horizontal: fixPadding),
                    height: 100,
                    width: 110.0,
                    decoration: BoxDecoration(
                      color: greyColor.withOpacity(0.15),
                      borderRadius: BorderRadius.circular(10.0),
                    ),
                    child: const Icon(
                      Icons.camera_alt_outlined,
                      color: greyColor,
                    ),
                  ),
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Widget briefComplaintField(Size size) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'raised_new_complaint.brief_your_complaint')),
        heightSpace,
        Container(
          height: size.height * 0.15,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            expands: true,
            maxLines: null,
            minLines: null,
            textAlignVertical: TextAlignVertical.top,
            style: regular15Black,
            cursorColor: primaryColor,
            decoration: InputDecoration(
              border: InputBorder.none,
              isDense: true,
              focusedBorder: focusedBorder,
              hintText:
                  tr(context, 'raised_new_complaint.brief_your_complaint'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  Widget selectComplaintType() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'raised_new_complaint.select_complaint_type')),
        heightSpace,
        Row(
          children: List.generate(
            complaintTypeList.length,
            (index) {
              return Expanded(
                child: GestureDetector(
                  onTap: () {
                    setState(() {
                      selectedComplaintType = index;
                    });
                  },
                  child: Container(
                    margin: languageValue == 4
                        ? (index == 1
                            ? const EdgeInsets.only(right: fixPadding)
                            : const EdgeInsets.only(left: fixPadding))
                        : (index == 0
                            ? const EdgeInsets.only(right: fixPadding)
                            : const EdgeInsets.only(left: fixPadding)),
                    padding: const EdgeInsets.all(fixPadding * 1.35),
                    decoration: BoxDecoration(
                      color: selectedComplaintType == index
                          ? primaryColor
                          : whiteColor,
                      borderRadius: BorderRadius.circular(10.0),
                      boxShadow: boxShadow,
                    ),
                    alignment: Alignment.center,
                    child: Text(
                      complaintTypeList[index].toString(),
                      style: selectedComplaintType == index
                          ? medium16White
                          : medium16Grey,
                      overflow: TextOverflow.ellipsis,
                    ),
                  ),
                ),
              );
            },
          ),
        )
      ],
    );
  }

  Widget complaintNameField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'raised_new_complaint.complaint_name')),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            cursorColor: primaryColor,
            style: regular15Black,
            keyboardType: TextInputType.name,
            decoration: InputDecoration(
              border: InputBorder.none,
              isDense: true,
              focusedBorder: focusedBorder,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
              hintText:
                  tr(context, 'raised_new_complaint.enter_complaint_name'),
              hintStyle: regular15Grey,
            ),
          ),
        )
      ],
    );
  }

  Text title(String text) {
    return Text(
      text,
      style: regular16Black,
    );
  }

  Widget addUserImage() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        GestureDetector(
          onTap: () {
            imageBottomSheet(
                tr(context, 'raised_new_complaint.add_your_image'));
          },
          child: Container(
            height: 100.0,
            width: 100.0,
            decoration: BoxDecoration(
              color: greyColor.withOpacity(0.15),
              borderRadius: BorderRadius.circular(10.0),
            ),
            alignment: Alignment.center,
            child: const Icon(
              Icons.camera_alt_outlined,
              color: greyColor,
            ),
          ),
        ),
        heightSpace,
        Text(
          tr(context, 'raised_new_complaint.add_your_image'),
          style: regular16Black,
          textAlign: TextAlign.center,
        )
      ],
    );
  }

  Future<dynamic> imageBottomSheet(String title) {
    return showModalBottomSheet(
      isScrollControlled: true,
      backgroundColor: whiteColor,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(
          top: Radius.circular(20.0),
        ),
      ),
      context: context,
      builder: (context) {
        return ListView(
          physics: const BouncingScrollPhysics(),
          shrinkWrap: true,
          padding: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
          children: [
            Text(
              title,
              style: medium16Black,
            ),
            heightSpace,
            heightSpace,
            height5Space,
            imageOptionWidget(Icons.camera_alt,
                tr(context, 'raised_new_complaint.camera'), darkBlueColor),
            heightSpace,
            heightSpace,
            imageOptionWidget(Icons.photo,
                tr(context, 'raised_new_complaint.gallery'), greenColor),
          ],
        );
      },
    );
  }

  Widget imageOptionWidget(IconData icon, String title, Color color) {
    return InkWell(
      splashColor: Colors.transparent,
      onTap: () {
        Navigator.pop(context);
      },
      child: Row(
        children: [
          Container(
            height: 40.0,
            width: 40.0,
            decoration: BoxDecoration(
              color: whiteColor,
              shape: BoxShape.circle,
              boxShadow: boxShadow,
            ),
            alignment: Alignment.center,
            child: Icon(
              icon,
              color: color,
            ),
          ),
          widthSpace,
          width5Space,
          Expanded(
            child: Text(
              title,
              style: regular16Black,
              overflow: TextOverflow.ellipsis,
            ),
          )
        ],
      ),
    );
  }
}
