import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class EditAddresScreen extends StatefulWidget {
  const EditAddresScreen({super.key});

  @override
  State<EditAddresScreen> createState() => _EditAddresScreenState();
}

class _EditAddresScreenState extends State<EditAddresScreen> {
  TextEditingController societynNameController = TextEditingController();
  TextEditingController buildingNameController = TextEditingController();
  TextEditingController flatNumberController = TextEditingController();

  @override
  void initState() {
    societynNameController.text = "Smart society";
    buildingNameController.text = "A wing";
    flatNumberController.text = "B-254";

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'edit_address.edit_address'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        children: [
          societyNameField(),
          heightSpace,
          heightSpace,
          height5Space,
          buildingField(),
          heightSpace,
          heightSpace,
          height5Space,
          flatNumberField(),
        ],
      ),
      bottomNavigationBar: updateButton(),
    );
  }

  Widget updateButton() {
    return Padding(
      padding: EdgeInsets.only(bottom: MediaQuery.viewInsetsOf(context).bottom),
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          margin: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'edit_address.update'),
            style: medium20White,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget flatNumberField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'edit_address.flat_number')),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            keyboardType: TextInputType.visiblePassword,
            controller: flatNumberController,
            decoration: InputDecoration(
              isDense: true,
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'edit_address.enter_Flat_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 1.5, vertical: fixPadding * 1.4),
            ),
          ),
        )
      ],
    );
  }

  Widget buildingField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'edit_address.building')),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            keyboardType: TextInputType.name,
            controller: buildingNameController,
            decoration: InputDecoration(
              isDense: true,
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'add_address.enter_bulilding_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 1.5, vertical: fixPadding * 1.4),
            ),
          ),
        )
      ],
    );
  }

  Widget societyNameField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'edit_address.society_name')),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            keyboardType: TextInputType.name,
            controller: societynNameController,
            decoration: InputDecoration(
              isDense: true,
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'edit_address.enter_society_name'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 1.5, vertical: fixPadding * 1.4),
            ),
          ),
        )
      ],
    );
  }

  Widget title(String text) {
    return Text(
      text,
      style: regular16Black,
    );
  }
}
