import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/ri.dart';

class NotificationScreen extends StatefulWidget {
  const NotificationScreen({super.key});

  @override
  State<NotificationScreen> createState() => _NotificationScreenState();
}

class _NotificationScreenState extends State<NotificationScreen> {
  final notificationList = [
    {
      "image": "assets/icons/notice-board.png",
      "title": "Notice board",
      "description": "Posted in helpdesk for plumbing",
      "time": "2min ago"
    },
    {
      "image": "assets/icons/uil_user.png",
      "title": "Admin",
      "description": "Approve your amenity booking",
      "time": "2min ago"
    },
    {
      "image": "assets/icons/notice-board.png",
      "title": "Notice board",
      "description": "Posted due payment for maintenance.",
      "time": "2min ago"
    },
    {
      "image": "assets/icons/cache-cleaner.png",
      "title": "Jenny wilsom",
      "description": "post in help desk for home cleaning.",
      "time": "2min ago"
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'notification.notification'),
          style: medium18Black,
        ),
      ),
      body: notificationList.isEmpty
          ? emptyListContent()
          : notificationListContent(),
    );
  }

  emptyListContent() {
    return Center(
      child: ListView(
        shrinkWrap: true,
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        children: [
          const Iconify(
            Ri.notification_off_line,
            color: greyColor,
            size: 40.0,
          ),
          heightSpace,
          Text(
            tr(context, 'notification.no_new_notification'),
            style: medium16Grey,
            textAlign: TextAlign.center,
          )
        ],
      ),
    );
  }

  notificationListContent() {
    return ListView.builder(
      itemCount: notificationList.length,
      padding: const EdgeInsets.symmetric(vertical: fixPadding * 1.25),
      itemBuilder: (context, index) {
        return Dismissible(
          key: UniqueKey(),
          onDismissed: (direction) {
            setState(() {
              notificationList.removeAt(index);
            });
            ScaffoldMessenger.of(context).showSnackBar(
              SnackBar(
                backgroundColor: originalBlackColor,
                behavior: SnackBarBehavior.floating,
                duration: const Duration(milliseconds: 1500),
                content: Text(
                  tr(context, 'notification.removed_from_notification'),
                  style: medium15White,
                ),
              ),
            );
          },
          background: Container(
            width: double.maxFinite,
            color: redColor,
            margin: const EdgeInsets.symmetric(vertical: fixPadding * 0.75),
          ),
          child: Container(
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding * 2.0, vertical: fixPadding),
            margin: const EdgeInsets.symmetric(vertical: fixPadding * 0.75),
            color: whiteColor,
            child: Row(
              children: [
                Container(
                  height: 50.0,
                  width: 50.0,
                  decoration: BoxDecoration(
                    color: recColor,
                    borderRadius: BorderRadius.circular(10.0),
                  ),
                  alignment: Alignment.center,
                  child: Image.asset(
                    notificationList[index]['image'].toString(),
                    height: 30.0,
                    fit: BoxFit.contain,
                  ),
                ),
                widthSpace,
                width5Space,
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        notificationList[index]['title'].toString(),
                        style: regular17Primary,
                      ),
                      heightBox(fixPadding * 0.4),
                      Text(
                        notificationList[index]['description'].toString(),
                        style: regular16Black,
                      ),
                      heightBox(fixPadding * 0.4),
                      Text(
                        notificationList[index]['time'].toString(),
                        style: regular14Grey,
                      ),
                    ],
                  ),
                )
              ],
            ),
          ),
        );
      },
    );
  }
}
