import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class NoticeBoardScreen extends StatefulWidget {
  const NoticeBoardScreen({super.key});

  @override
  State<NoticeBoardScreen> createState() => _NoticeBoardScreenState();
}

class _NoticeBoardScreenState extends State<NoticeBoardScreen> {
  final noticeList = [
    {
      "title": "Announcement",
      "dateTime": "19 Dec, 5:30 PM",
      "notice": "New year gathering in Seven gen society's hall on 1 st January"
    },
    {
      "title": "Announcement",
      "dateTime": "16 Jan, 5:30 PM",
      "notice":
          "Increasing maintenance to \$20 from  next month due to security increments"
    },
    {
      "title": "Announcement",
      "dateTime": "19 Jan, 3:15 PM",
      "notice":
          "Society meeting about water management in our society at community hall tomorrow. "
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'notice_board.notice_board'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.only(bottom: fixPadding),
        children: [
          topImage(),
          heightSpace,
          noticeListContent(),
        ],
      ),
    );
  }

  noticeListContent() {
    return ColumnBuilder(
      itemCount: noticeList.length,
      itemBuilder: (context, index) {
        final itemData = noticeList[index];
        return Container(
          margin: const EdgeInsets.symmetric(vertical: fixPadding),
          padding: const EdgeInsets.all(fixPadding * 2.0),
          width: double.maxFinite,
          color: whiteColor,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  const Icon(
                    Icons.notifications_active_outlined,
                    color: primaryColor,
                    size: 18.0,
                  ),
                  widthSpace,
                  Expanded(
                    child: Text(
                      itemData['title'].toString(),
                      style: medium16Primary,
                      overflow: TextOverflow.ellipsis,
                    ),
                  ),
                  widthSpace,
                  Text(
                    itemData['dateTime'].toString(),
                    style: regular14Grey,
                  )
                ],
              ),
              heightSpace,
              Text(
                noticeList[index]['notice'].toString(),
                style: regular15Grey,
              )
            ],
          ),
        );
      },
    );
  }

  topImage() {
    return Image.asset(
      "assets/community/notice-board.png",
      height: 128.0,
      width: double.maxFinite,
      fit: BoxFit.cover,
    );
  }
}
