import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/ri.dart';
import 'package:im_animations/im_animations.dart';

class CallScreen extends StatefulWidget {
  const CallScreen({super.key});

  @override
  State<CallScreen> createState() => _CallScreenState();
}

class _CallScreenState extends State<CallScreen> {
  bool volumOff = false;
  bool mute = true;

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
        children: [
          SizedBox(
            height: size.height,
            width: size.width,
            child: Column(
              children: [
                heightBox(size.height * 0.09),
                image(),
                heightSpace,
                heightSpace,
                heightSpace,
                heightSpace,
                heightSpace,
                heightSpace,
                const Text(
                  "Calling...",
                  style: medium18Primary,
                  textAlign: TextAlign.center,
                ),
                height5Space,
                const Text(
                  "Brooklyn Simmons",
                  style: medium17Black,
                  textAlign: TextAlign.center,
                ),
                const Spacer(),
                callOptions(),
                heightSpace,
                heightSpace,
                heightSpace,
                endCallButton(context),
                heightBox(size.height * 0.08)
              ],
            ),
          ),
        ],
      ),
    );
  }

  endCallButton(BuildContext context) {
    return GestureDetector(
      onTap: () {
        Navigator.pop(context);
      },
      child: Container(
        height: 50.0,
        width: 50.0,
        decoration: const BoxDecoration(
          color: lightRedColor,
          shape: BoxShape.circle,
        ),
        child: const Icon(
          Icons.call_end,
          color: whiteColor,
        ),
      ),
    );
  }

  callOptions() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: [
        Opacity(
          opacity: mute ? 0.5 : 1.0,
          child: GestureDetector(
            onTap: () {
              setState(() {
                mute = !mute;
              });
            },
            child: Container(
              height: 50.0,
              width: 50.0,
              decoration: const BoxDecoration(
                shape: BoxShape.circle,
                color: primaryColor,
              ),
              alignment: Alignment.center,
              child: Icon(
                mute ? CupertinoIcons.mic_off : CupertinoIcons.mic,
                color: whiteColor,
                size: 28,
              ),
            ),
          ),
        ),
        Opacity(
          opacity: !volumOff ? 0.5 : 1.0,
          child: GestureDetector(
            onTap: () {
              setState(() {
                volumOff = !volumOff;
              });
            },
            child: Container(
              height: 50.0,
              width: 50.0,
              decoration: const BoxDecoration(
                shape: BoxShape.circle,
                color: primaryColor,
              ),
              alignment: Alignment.center,
              child: Icon(
                volumOff ? Icons.volume_off_outlined : Icons.volume_up_outlined,
                color: whiteColor,
                size: 28,
              ),
            ),
          ),
        ),
        Opacity(
          opacity: 0.5,
          child: GestureDetector(
            onTap: () {
              Navigator.pushNamed(context, '/chat');
            },
            child: Container(
              height: 50.0,
              width: 50.0,
              decoration: const BoxDecoration(
                shape: BoxShape.circle,
                color: primaryColor,
              ),
              alignment: Alignment.center,
              child: const Iconify(
                Ri.message_3_line,
                color: whiteColor,
                size: 28,
              ),
            ),
          ),
        ),
      ],
    );
  }

  image() {
    return Container(
      margin: const EdgeInsets.only(top: fixPadding * 4.0),
      child: ColorSonar(
        contentAreaRadius: 70.0,
        waveFall: 30.0,
        innerWaveColor: const Color(0xFFFFD4C5),
        middleWaveColor: const Color(0xFFF6EAE6).withOpacity(0.6),
        outerWaveColor: const Color(0xFFF6EAE6).withOpacity(0.0),
        waveMotion: WaveMotion.synced,
        duration: const Duration(seconds: 2),
        waveMotionEffect: Curves.easeInOut,
        child: CircleAvatar(
          radius: 80.0,
          backgroundColor: primaryColor,
          child: Image.asset(
            "assets/call/call-image.png",
            fit: BoxFit.cover,
          ),
        ),
      ),
    );
  }
}
