import 'dart:io';
import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/screens/screens.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/material_symbols.dart';
import 'package:iconify_flutter/icons/mdi.dart';
import 'package:iconify_flutter/icons/mi.dart';
import 'package:iconify_flutter/icons/ph.dart';

class BottomBar extends StatefulWidget {
  const BottomBar({super.key});

  @override
  State<BottomBar> createState() => _BottomBarState();
}

class _BottomBarState extends State<BottomBar> {
  DateTime? backPressTime;

  int selectedIndex = 0;

  final pages = const [
    HomeScreen(),
    MembersScreen(),
    BirthdayScreen(),
    ProfileScreen(),
  ];

  @override
  Widget build(BuildContext context) {
    return PopScope(
      canPop: false,
      onPopInvokedWithResult: (didPop, result) {
        bool backStatus = onWillPop();
        if (backStatus) {
          exit(0);
        }
      },
      child: Scaffold(
        body: pages.elementAt(selectedIndex),
        bottomNavigationBar: bottomBar(context),
      ),
    );
  }

  bottomBar(BuildContext context) {
    return Theme(
      data: Theme.of(context).copyWith(
        splashColor: Colors.transparent,
      ),
      child: BottomNavigationBar(
        onTap: (index) {
          setState(() {
            selectedIndex = index;
          });
        },
        currentIndex: selectedIndex,
        backgroundColor: whiteColor,
        selectedItemColor: primaryColor,
        showSelectedLabels: true,
        showUnselectedLabels: true,
        selectedLabelStyle: medium16Primary,
        unselectedLabelStyle: medium16GreyB4,
        unselectedItemColor: greyB4Color,
        type: BottomNavigationBarType.fixed,
        items: [
          itemWidget(Mi.home, tr(context, 'bottom_bar.home')),
          itemWidget(
              Ph.chat_circle_text_bold, tr(context, 'bottom_bar.members')),
          itemWidget(MaterialSymbols.design_services,
              tr(context, 'bottom_bar.birthday')),
          itemWidget(Mdi.user_outline, tr(context, 'bottom_bar.settings')),
        ],
      ),
    );
  }

  itemWidget(String icon, String label) {
    return BottomNavigationBarItem(
      icon: Padding(
        padding: const EdgeInsets.only(top: fixPadding / 3),
        child: Iconify(
          icon,
          color: greyB4Color,
        ),
      ),
      activeIcon: Padding(
        padding: const EdgeInsets.only(top: fixPadding / 3),
        child: Iconify(
          icon,
          color: primaryColor,
        ),
      ),
      label: label,
    );
  }

  onWillPop() {
    DateTime now = DateTime.now();
    if (backPressTime == null ||
        now.difference(backPressTime!) >= const Duration(seconds: 2)) {
      backPressTime = now;
      ScaffoldMessenger.of(context).showSnackBar(
        SnackBar(
          backgroundColor: originalBlackColor,
          content: Text(
            tr(context, 'exit_app.exit_text'),
            style: medium15White,
          ),
          behavior: SnackBarBehavior.floating,
          duration: const Duration(milliseconds: 1500),
        ),
      );
      return false;
    } else {
      return true;
    }
  }
}
