import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/calendar_dialog.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class BookAmenitiesDetailScreen extends StatefulWidget {
  const BookAmenitiesDetailScreen({super.key});

  @override
  State<BookAmenitiesDetailScreen> createState() =>
      _BookAmenitiesDetailScreenState();
}

class _BookAmenitiesDetailScreenState extends State<BookAmenitiesDetailScreen> {
  DateTime? selectedFromDate;
  DateTime? selectedToDate;

  TimeOfDay? selectedFromTime;
  TimeOfDay? selectedToTime;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'book_amenities_detail.book_amenities'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.symmetric(vertical: fixPadding * 2.0),
        children: [
          amenityDetail(),
          heightSpace,
          heightSpace,
          height5Space,
          selectDate(context),
          heightSpace,
          heightSpace,
          height5Space,
          selectTime(context)
        ],
      ),
      bottomNavigationBar: bookDetailAndPayButton(context),
    );
  }

  bookDetailAndPayButton(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(
          vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
      width: double.maxFinite,
      color: whiteColor,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Row(
            children: [
              Expanded(
                child: Text(
                  tr(context, 'book_amenities_detail.total_day'),
                  style: regular17Black,
                ),
              ),
              widthSpace,
              const Text(
                "3 day",
                style: regular17Black,
              )
            ],
          ),
          heightSpace,
          height5Space,
          Row(
            children: [
              Expanded(
                child: Text(
                  tr(context, 'book_amenities_detail.total_payment'),
                  style: regular17Black,
                ),
              ),
              widthSpace,
              const Text(
                "\$60.00",
                style: regular17Primary,
              )
            ],
          ),
          heightSpace,
          heightSpace,
          height5Space,
          GestureDetector(
            onTap: () {
              Navigator.pushNamed(context, '/creditcard');
            },
            child: Container(
              padding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
              width: double.maxFinite,
              decoration: BoxDecoration(
                  color: primaryColor,
                  borderRadius: BorderRadius.circular(10.0),
                  boxShadow: buttonShadow),
              child: Text(
                tr(context, 'book_amenities_detail.proceed_to_pay'),
                style: medium20White,
                overflow: TextOverflow.ellipsis,
                textAlign: TextAlign.center,
              ),
            ),
          )
        ],
      ),
    );
  }

  selectTime(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            tr(context, 'book_amenities_detail.select_time'),
            style: regular17Black,
          ),
          heightSpace,
          Row(
            children: [
              fromTime(context),
              widthSpace,
              widthSpace,
              toTime(context),
            ],
          ),
        ],
      ),
    );
  }

  toTime(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () async {
          final pickedTime = await showTimePicker(
            context: context,
            initialTime: selectedToTime ?? TimeOfDay.now(),
            cancelText: tr(context, 'book_amenities_detail.CANCEL'),
            confirmText: tr(context, 'book_amenities_detail.OK'),
          );
          if (pickedTime != null) {
            setState(() {
              selectedToTime = pickedTime;
            });
          }
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedToTime == null
              ? Text(
                  tr(context, 'book_amenities_detail.to'),
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  selectedToTime!.format(context),
                  style: regular16Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  fromTime(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () async {
          final pickedTime = await showTimePicker(
            context: context,
            initialTime: selectedFromTime ?? TimeOfDay.now(),
            cancelText: tr(context, 'book_amenities_detail.CANCEL'),
            confirmText: tr(context, 'book_amenities_detail.OK'),
          );
          if (pickedTime != null) {
            setState(() {
              selectedFromTime = pickedTime;
            });
          }
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedFromTime == null
              ? Text(
                  tr(context, 'book_amenities_detail.from'),
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  selectedFromTime!.format(context),
                  style: regular16Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  selectDate(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            tr(context, 'book_amenities_detail.select_date'),
            style: regular17Black,
          ),
          heightSpace,
          Row(
            children: [
              fromDate(context),
              widthSpace,
              widthSpace,
              toDate(context),
            ],
          )
        ],
      ),
    );
  }

  toDate(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () {
          showDialog(
            context: context,
            builder: (context) {
              return CalendarDialog(selectedDate: selectedToDate);
            },
          ).then((value) {
            if (value != null) {
              setState(() {
                selectedToDate = value;
              });
            }
          });
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedToDate == null
              ? Text(
                  tr(context, 'book_amenities_detail.to'),
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  DateFormat("dd MMM yyyy",
                          Localizations.localeOf(context).toString())
                      .format(selectedToDate!),
                  style: regular16Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  fromDate(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () {
          showDialog(
            context: context,
            builder: (context) {
              return CalendarDialog(selectedDate: selectedFromDate);
            },
          ).then((value) {
            if (value != null) {
              setState(() {
                selectedFromDate = value;
              });
            }
          });
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedFromDate == null
              ? Text(
                  tr(context, 'book_amenities_detail.from'),
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  DateFormat("dd MMM yyyy",
                          Localizations.localeOf(context).toString())
                      .format(selectedFromDate!),
                  style: regular16Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  amenityDetail() {
    return Container(
      padding: const EdgeInsets.symmetric(
          horizontal: fixPadding * 2.0, vertical: fixPadding),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: whiteColor,
        boxShadow: boxShadow2,
      ),
      child: Row(
        children: [
          const Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  "Community hall",
                  style: regular17Black,
                  overflow: TextOverflow.ellipsis,
                ),
                height5Space,
                Text(
                  "Maximum capacity : 50 person",
                  style: regular15Grey,
                  overflow: TextOverflow.ellipsis,
                ),
                height5Space,
                Text(
                  "\$60 per day",
                  style: regular15Primary,
                )
              ],
            ),
          ),
          widthSpace,
          Text(
            tr(context, 'book_amenities_detail.paid'),
            style: medium16Primary,
          )
        ],
      ),
    );
  }
}
