import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/calendar_dialog.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class AddGuestScreen extends StatefulWidget {
  const AddGuestScreen({super.key});

  @override
  State<AddGuestScreen> createState() => _AddGuestScreenState();
}

class _AddGuestScreenState extends State<AddGuestScreen> {
  DateTime? selectedDate;

  bool isSendPass = true;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.fromLTRB(fixPadding * 2.0, fixPadding * 3.0,
            fixPadding * 2.0, fixPadding * 2.0),
        physics: const BouncingScrollPhysics(),
        children: [
          logoAndContent(),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          guestNameField(),
          heightSpace,
          heightSpace,
          height5Space,
          mobileNumberField(),
          heightSpace,
          heightSpace,
          height5Space,
          dateField(),
          heightSpace,
          height5Space,
          sendPassCheckBox(),
        ],
      ),
      bottomNavigationBar: submitButton(context),
    );
  }

  Widget submitButton(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(
        bottom: MediaQuery.viewInsetsOf(context).bottom,
      ),
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          width: double.maxFinite,
          margin: const EdgeInsets.symmetric(
              vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'add_guest.submit'),
            style: medium20White,
            textAlign: TextAlign.center,
            overflow: TextOverflow.ellipsis,
          ),
        ),
      ),
    );
  }

  Widget sendPassCheckBox() {
    return Row(
      children: [
        GestureDetector(
          onTap: () {
            setState(() {
              isSendPass = !isSendPass;
            });
          },
          child: Container(
            height: 16.0,
            width: 16.0,
            decoration: BoxDecoration(
              color: whiteColor,
              borderRadius: BorderRadius.circular(2.0),
              boxShadow: boxShadow2,
              border: Border.all(color: primaryColor),
            ),
            child: isSendPass
                ? const Icon(
                    Icons.done,
                    color: primaryColor,
                    size: 13.0,
                  )
                : const SizedBox(),
          ),
        ),
        widthSpace,
        Expanded(
          child: Text(
            tr(context, 'add_guest.send_gate_pass_to_guest'),
            style: regular14Primary,
          ),
        )
      ],
    );
  }

  Widget dateField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          tr(context, 'add_guest.to_enter'),
          style: regular16Black,
        ),
        heightSpace,
        GestureDetector(
          onTap: () {
            showDialog(
              context: context,
              builder: (context) {
                return CalendarDialog(selectedDate: selectedDate);
              },
            ).then((value) {
              if (value != null) {
                setState(() {
                  selectedDate = value;
                });
              }
            });
          },
          child: Container(
            padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3,
              horizontal: fixPadding * 1.5,
            ),
            decoration: BoxDecoration(
              color: whiteColor,
              borderRadius: BorderRadius.circular(10.0),
              boxShadow: boxShadow2,
            ),
            child: Row(
              children: [
                Expanded(
                  child: selectedDate == null
                      ? Text(
                          tr(context, 'add_guest.select_date'),
                          style: regular15Grey,
                          overflow: TextOverflow.ellipsis,
                        )
                      : Text(
                          DateFormat("dd MMMM yyyy",
                                  Localizations.localeOf(context).toString())
                              .format(selectedDate!),
                          style: regular15Black,
                          overflow: TextOverflow.ellipsis,
                        ),
                ),
                widthSpace,
                const Icon(
                  Icons.arrow_drop_down,
                  color: greyColor,
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Widget mobileNumberField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          tr(context, 'add_guest.mobile_number'),
          style: regular16Black,
        ),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            cursorColor: primaryColor,
            keyboardType: TextInputType.phone,
            style: regular15Black,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              hintText: tr(context, 'add_guest.enter_mobile_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                vertical: fixPadding * 1.4,
                horizontal: fixPadding * 1.5,
              ),
            ),
          ),
        )
      ],
    );
  }

  Widget guestNameField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          tr(context, 'add_guest.guest_name'),
          style: regular16Black,
        ),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            keyboardType: TextInputType.name,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
              hintText: tr(context, 'add_guest.enter_guest_name'),
              hintStyle: regular15Grey,
            ),
          ),
        )
      ],
    );
  }

  Widget logoAndContent() {
    return Column(
      children: [
        Container(
          height: 100.0,
          width: 100.0,
          decoration: const BoxDecoration(
            shape: BoxShape.circle,
            color: primaryColor,
          ),
          alignment: Alignment.center,
          child: Image.asset(
            "assets/icons/guest.png",
            height: 50.0,
            fit: BoxFit.contain,
          ),
        ),
        height5Space,
        Text(
          tr(context, 'add_guest.allow_my_guest'),
          style: medium17Primary,
          textAlign: TextAlign.center,
        ),
      ],
    );
  }
}
